#ifndef ZMODELER_CDIRECT3D_INCLUDED
#define ZMODELER_CDIRECT3D_INCLUDED

#include "3dedefs.h"

#define D3D_OVERLOADS

#include <D3D\D3DFrame.h>
#include <D3D\D3DTextr.h>
#include <D3D\D3DEnum.h>
#include <D3D\D3DUtil.h>
#include <D3D\D3DMath.h>

#include "tRenderBlock.h"
#include "tMaterials.h"


class AFX_EXT_CLASS CDirect3D
{
  POINT         PressedAt;
  DWORD         DeviceFlags;
  HWND          Owner;
  D3DTLVERTEX   g_Background[4];
private:
  char          DesiredDevice[64];
public:
  //-----------------------------------------------------------------------------
  // Global variables
  //-----------------------------------------------------------------------------

  CD3DFramework7*   g_pFramework;
  D3DDEVICEINFO*    m_pDeviceInfo;    //currently selected
  BOOL              g_bActive;
  BOOL              g_bReady;
  BOOL              Perspectived;
  long              BackgroundMaterialIndex;//when you turn Mapper ON
  long              BackgroundImageIndex;   //when background image is on
  
  LPD3DLIGHT7       DirectLight;        //Directional
  LPD3DLIGHT7       SpotLight[4];       //Spots
  LPD3DLIGHT7       BackLight;          //BackLight directional
  DWORD             LStandart;          //bit enabled, + RGB color
  DWORD             LAmbient;           //bit enabled, + RGB color
  DWORD             LSpots[4];          //bit enabled, + RGB color
  DWORD             LBack;              //bit enabled, + RGB color
  DWORD             Background;         //bit Image        (32)
                                        //bit Rotateable image  (31)
                                        //bit environment mapping (30)
                                        //if Color, then + RGB color; else use BackgroundImageIndex;
  DWORD             Wireframe;          //bit Enabled       (32)
                                        //bit Shaded        (31)
                                        //bit Textured      (30)
                                        //(0-24) - RGB Color

  DWORD     ActiveHighlight,  //BitEnabled          (32)
                              //AdditiveHighLight   (31)
                              //ExtraHighLight      (30)
                              //NonTransparent      (29)
                              //CustomColor         (28)
            SelectedHighlight,
            SelActiveHighlight,
            DotsHighlight,
            NormalsHighlight;
  DWORD     Fog;              //bit enabled, + RGB color


  float     SemiTransparencyFactor;  //0.0f..1.0f
  long      MouseSensitivity;        //1..10;

  float     fogstart,                // [0..1]
            fogend,                  // [0..1]
            fogdensity;              // [0..1] or upto 2.0f

  D3DVECTOR Camera;
  D3DVECTOR CamTarget;
  D3DVECTOR CamUpVector;

  float     CamFOV;
  float     CamSlope;

  float     BackImageOffsetX,
            BackImageOffsetY,
            BackImageZoom;
  
  tMaterials  Materials;



  //-----------------------------------------------------------------------------
  // Construction/Deconstruction
  //-----------------------------------------------------------------------------
  CDirect3D();
  
  
  //-----------------------------------------------------------------------------
  // Initialization
  //-----------------------------------------------------------------------------
  BOOL    Init3DEngine(HWND hWnd);
  HRESULT Change3DEnvironment();

  //-----------------------------------------------------------------------------
  // Finalization
  //-----------------------------------------------------------------------------
  void    Cleanup3DEnvironment();

  //-----------------------------------------------------------------------------
  // Rendering functions;
  //-----------------------------------------------------------------------------
  void  Prepare3DEnvironment(BOOL ClearTarget, BOOL ClearZBuffer, RECT* OutRect);
  void  RenderBlocks(tRenderBlock *pBlocks, long NumOfBlocks);
  void  Non3DWireDraw(
            tWireBlock*  Block,
            RECT    OutRect,
            BOOL    WireStage,
            BOOL    SolidStage);

  void  ShowFrame(RECT* srcrect, RECT* destrect);
  void  ShowFrame(CDC* pTargetDC, long width, long height);

  void  ResetCamera();
  //Device Flags read/writers
  void  SetDeviceFlags(DWORD set)   {DeviceFlags = set; }
  DWORD GetDeviceFlags()            {return DeviceFlags;}
  void  SelectDevice();
  void  ChangeDeviceFlag(DWORD flag, BOOL SetFlag);

  void  ChangePerspective(BOOL On);

  void  SelectMaterial(long index, DWORD nBlockFlags);
  long  CreateMaterial(
              float red,          //0,0 .. 1,0
              float green,        //0,0 .. 1,0
              float blue,         //0,0 .. 1,0
              float opacity,      //0,0 .. 1,0
              float shine,        //[0.0f..1.0f]
              float shinestrength,//[0.0f..100.0f]
              char* PrimName,
              char* BumpName,
              char* ReflName,
              char* RsrvName,
              char* matname,
              DWORD nTexturesFlags  = TEX_NAMEPATHMATCH_NOCASE |
                                      TEX_NAMEPATHMATCH_NAMEONLY,
              D3DTEXTUREOP PrimA  = D3DTOP_MODULATE,
              D3DTEXTUREOP BumpA  = D3DTOP_DISABLE,
              D3DTEXTUREOP ReflA  = D3DTOP_ADD,
              D3DTEXTUREOP RsrvA  = D3DTOP_DISABLE,
              D3DBLEND SBlend      = D3DBLEND_SRCALPHA,
              D3DBLEND DBlend      = D3DBLEND_INVSRCALPHA,
              BYTE AlphaT          = 0,
              BYTE AlphaREF        = 0x80,
              BYTE AlphaFunc      = (BYTE)D3DCMP_NEVER,
              DWORD ColorKeyLowValue  = 0x00000000,
              DWORD ColorKeyHighValue = 0x00000000,
              BOOL  CanUseExistenMaterials = TRUE);
  long  FindMaterial(  DWORD  nMatchFlags,
              char* PrimName    = NULL,
              char* BumpName    = NULL,
              char* ReflName    = NULL,
              char* RsrvName    = NULL,
              DWORD rgba        = 0xFFFFFFFF,
              char* matname      = NULL,
              D3DTEXTUREOP PrimA= D3DTOP_MODULATE,
              D3DTEXTUREOP BumpA= D3DTOP_DISABLE,
              D3DTEXTUREOP ReflA= D3DTOP_ADD,
              D3DTEXTUREOP RsrvA= D3DTOP_DISABLE,
              BYTE AlphaT        = 0);

  void  RestoreMaterials();
  void  RestoreTexture(long index);

  void  ChangeViewPosition();
  void  UpdateBackground();
  void  UpdateLights();
  void  SetFOG(long f, float start, float end, float density); //sets FOG properties
  void  SetBackground(DWORD back);

  void  Enable(BOOL Activate);
  void  D3DPause( BOOL bPause );

  void  OnButtonDown(UINT nFlags, POINT loc);
  void  OnMoveView(long x, long y);
  BOOL  OnMouseMove(UINT nFlags, POINT loc);
  BOOL  OnKeyDown( UINT nChar, UINT nRepCnt, UINT nFlags );

private:
  //-----------------------------------------------------------------------------
  // Internal function-prototypes
  //-----------------------------------------------------------------------------
  HRESULT D3D_OneTimeSceneInit();
  // initialiases deviced : soft-/hard-ware.
  HRESULT D3DInitialize();
  // initialiases Enviroment: lights, materials...
  HRESULT Initialize3DEnvironment();
  void  D3D_DeleteDeviceObjects( LPDIRECT3DDEVICE7);
  HRESULT D3D_InitDeviceObjects( LPDIRECT3DDEVICE7);

  HRESULT D3D_FinalCleanup( LPDIRECT3DDEVICE7);
  void    DisplayFrameworkError(HRESULT);

public:
  //--------------------------
  //  UTILITES
  //--------------------------
  void MakeD3DRect(D3DRECT *d3dr, RECT *cr);
  void LookAt(float eyex, float eyey, float eyez,
        float tox, float toy, float toz,
        float Slope, float FOV);
  void SetWireView(z3dViewDescriptor* pDesc, tPOINT* SceneMinBound, tPOINT* SceneMaxBound );
  void DrawTexturedRect(  RECT*  prcViewportRect,
              BOOL  ClearTarget,
              DWORD nFlags,
              long  MaterialIndex,
              long  TextureIndex,
              RECT  rect);

};



#endif /* ZMODELER_CDIRECT3D_INCLUDED*/
